/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.verifications;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatDouble;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class VerifierSignatureMessage {
    private static Logger log = Logger.getLogger(VerifierSignatureMessage.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2, long l3, char[] cArray, String string) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                if (cArray != null) {
                    CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
                    cK_MECHANISM.mechanism = l2;
                    ResultatDouble resultatDouble = new ResultatDouble("V\u00e9rification de la signature d'un message avec " + TraitementsUtil.getNomAlgo(l2) + " (Initialisation (C_VerifyInit))", "V\u00e9rification de la signature d'un message avec " + TraitementsUtil.getNomAlgo(l2) + " (V\u00e9rification (C_Verify))");
                    if (cArray != null) {
                        byte[] byArray = TraitementsUtil.getOctetsSansFormatage(string);
                        boolean bl = false;
                        try {
                            pKCS11.C_VerifyInit(l, cK_MECHANISM, l3);
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatDouble.setCodeRetour(pKCS11Exception.getErrorCode());
                            bl = true;
                            resultatDouble.setCodeRetour2(-1L);
                            resultatDouble.appendOperation2(" NON EXECUTEE!");
                        }
                        try {
                            if (!bl) {
                                pKCS11.C_Verify(l, new String(cArray).getBytes(), byArray);
                            }
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatDouble.setCodeRetour2(pKCS11Exception.getErrorCode());
                        }
                    }
                    return resultatDouble;
                }
                log.error((Object)"Le message est nul");
                throw new ExceptionTraitement(31, "Le message est nul");
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(31, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(31, "Une erreur inattendue est survenue");
        }
    }
}

